
#total imports and tariff revenue collected between April-August 2025, by country, HS-08

country_total <-cifval_country %>%
  mutate(month = as.character(month)) %>%
  
  left_join(
    cald_country %>% mutate(month = as.character(month)),
    by = c("hs08", "month", "country")
  ) %>%
  mutate(
    across(
      c(cald_2025, cifval_2025),
      ~ as.numeric(as.character(.x))
    )
  )
  
# select products covered by this EO
country_food <-country_total %>%  
  # filtered by the exempted HS08 codes
  semi_join(
    food_tariffs_hs08 %>% mutate(hs08 = as.character(hs08)),
    by = "hs08"
  ) %>%
  # collapse to country totals
  group_by(country) %>%
  summarise(
    food_cald25 = sum(cald_2025, na.rm = TRUE),
    food_cif25  = sum(cifval_2025,  na.rm = TRUE),
    .groups = "drop")

#Total imports and tariff revenue collected by country (aggregated)
country_total_collapsed <- country_total %>%
  # collapse to hs08 cumulative totals
  group_by(country) %>%
  summarise(
    total_cald25 = sum(cald_2025, na.rm = TRUE),
    total_cif25  = sum(cifval_2025,  na.rm = TRUE),
    .groups = "drop")

#Data for figure 2
figure2 <- country_total_collapsed %>%
  left_join(country_food, by = c("country")) %>%
  mutate(
    #this helps understand how much tariffs paid between apr-aug are exempted
    foodtariff_percentageof_totaltariff= food_cald25/total_cald25
  )%>%
  arrange(desc(foodtariff_percentageof_totaltariff))

